/**
 * \file: MediaBrowserChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: AAuto
 *
 * \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
 *
 * \copyright (c) 2013-2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_MEDIABROWSER_CHANNEL_H
#define AAUTO_MEDIABROWSER_CHANNEL_H

#include <string>
#include <aauto/GalReceiver.h>
#include <aauto/IMediaBrowserCallbacks.h>
#include <aauto/util/shared_ptr.h>
#include <aauto/AditMediaBrowser.h>

namespace adit { namespace aauto {

class MediaBrowserChannel : public IAditMediaBrowserCallbacks
{
public:
    MediaBrowserChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId);
    virtual ~MediaBrowserChannel();

    bool Initialize();
    void shutdown();

    int reportAction(const std::string& path, uint32_t action);
    int mediaGetNode(const std::string& path, uint32_t start, bool get_album_art);

    // inherit IAditMediaBrowserCallbacks
    void rootNodeCallback(const struct MediaRootNodeStruct& node);
    void sourceNodeCallback(const struct MediaSourceNodeStruct& node);
    void listNodeCallback(const struct MediaListNodeStruct& node);
    void songNodeCallback(const struct MediaSongNodeStruct& node);
private:
    uint8_t mSessionId;
    ::shared_ptr<GalReceiver> mReceiver;
    ::shared_ptr<AditMediaBrowser> mEndpoint;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_MEDIABROWSER_CHANNEL_H */
